//引入MD5文件
const md5 = require('md5.js');

//Api请求封装
function api_request(url, method, parm) {

  var apiurl = 'http://pboot.syabq.cn/api.php';
  var appid = 'wx0a7f3cf5b9c1a347';
  var appsecret = 'ffd455cd59c050e536ecedc9c390b7da';
  var timestamp = Date.parse(new Date());
  timestamp = timestamp / 1000;
  var signature = md5.hex_md5(md5.hex_md5(appid + appsecret + timestamp));

  var data = {
    appid: appid,
    timestamp: timestamp,
    signature: signature,
  };

  //根据请求方法构建Header
  if (method == 'POST') {
    //POST方法
    var header = { 'Content-Type': 'application/x-www-form-urlencoded; charset=utf-8' };

    //添加POST参数到data
    for (var i in parm) {
      data[i] = parm[i];
    }
  } else {
    //GET方法
    method = 'GET';
    var header = { 'Content-Type': 'application/json' };
  }
  var promise = new Promise(function (resolve, reject) {

    wx.request({
      method: method,
      url: apiurl + url,
      header: header,
      data: data,

      success: function (res) {
        var apiData = res.data;
        if (apiData.code != 1 && apiData.code != 0) {
          reject({ error: '数据请求失败，请稍后重试', code: 500 });
          return;
        } else {
          resolve(apiData);
        }
      }
    })
  })
  return promise;
}

//Api模块
module.exports = {

  //获取公司信息
  companyInfos: function () {
    var url = '/cms/company';
    return api_request(url);
  },

  //获取单个公司信息
  companyInfo: function (name) {
    var url = '/cms/company/name/' + name;
    return api_request(url);
  },

  //获取网站信息
  siteInfos: function () {
    var url = '/cms/site';
    return api_request(url);
  },

  //获取单个网站信息
  siteInfo: function (name) {
    var url = '/cms/site/name/' + name;
    return api_request(name);
  },

  //获取自定义标签
  getLabels: function () {
    var url = '/cms/label';
    return api_request(url);
  },

  //获取单个自定义标签
  getLabel: function () {
    var url = '/cms/label/name/' + name;
    return api_request(url);
  },

  //获取幻灯片
  getSlide: function (gid, num) {
    var url = '/cms/slide/gid/' + gid + '/num/' + num;
    return api_request(url);
  },

  //获取友情链接
  getLinks: function (gid, num) {
    var url = '/cms/link/gid/' + gid + '/num/' + num;
    return api_request(url);
  },

  //获取栏目列表
  getNavs: function () {
    var url = '/cms/nav';
    return api_request(url);
  },

  //获取指定栏目列表
  getNav: function (scode) {
    var url = '/cms/nav/scode/' + scode;
    return api_request(url);
  },

  //获取当前栏目
  getCurrentCat: function (scode) {
    var url = '/cms/sort/scode/' + scode;
    return api_request(url);
  },

  //获取内容列表
  getList: function (scode, num, order) {
    if ((num != '') && !order) {
      var url = '/list/' + scode + '/num/' + num;
    } else if (!num && (order != '')) {
      var url = '/list/' + scode + '/order/' + order;
    } else if ((num != '') && (order != '')) {
      var url = '/list/' + scode + '/num/' + num + '/order/' + order;
    } else {
      var url = '/list/' + scode;
    }
    return api_request(url);
  },

  //获取内容列表第*页
  getListPage: function (scode, paged, num, order) {
    if ((num != '') && (order == '')) {
      var url = '/list/' + scode + '/num/' + num + '/page/' + paged;
    } else if ((num == '') && (order != '')) {
      var url = '/list/' + scode + '/order/' + order + '/page/' + paged;
    } else if ((num != '') && (order != '')) {
      var url = '/list/' + scode + '/num/' + num + '/order/' + order + '/page/' + paged;
    } else {
      var url = '/list/' + scode + '/page/' + paged;
    }
    return api_request(url);
  },

  //获取指定内容
  getContent: function (id) {
    var url = '/content/' + id;
    return api_request(url);
  },

  //获取指定单页详情
  getAbout: function (scode) {
    var url = '/about/' + scode;
    return api_request(url);
  },

  //获取指定内容多图
  getContentPics: function (id) {
    var url = '/cms/pics/id/' + id;
    return api_request(url);
  },

  //获取搜索结果
  getSearchResault: function (parm, num, order) {
    if ((num != '') && (order == '')) {
      var url = '/cms/search/' + 'num/' + num;
    } else if ((num == '') && (order != '')) {
      var url = '/cms/search/' + 'oder/' + order;
    } else if ((num != '') && (order != '')) {
      var url = '/cms/search/num/' + num + '/order/' + order;
    } else {
      var url = '/cms/search/';
    }
    return api_request(url, 'POST', parm);
  },

  //提交留言
  addMessage: function (parm) {
    var url = '/cms/addmsg';
    return api_request(url, 'POST', parm);
  },

  //获取留言内容
  getMessage: function (num) {
    var url = '/cms/msg/num/' + num;
    return api_request(url);
  },

  //获取留言内容第*页
  getMessagePaged: function (num, paged) {
    var url = '/cms/msg/num/' + num + '/page/' + paged;
    return api_request(url);
  },

  //提交表单
  addForm: function (fcode, parm) {
    var url = '/cms/addform/fcode/' + fcode;
    return api_request(url, 'POST', parm);
  },

  //获取表单内容
  getForm: function (fcode) {
    var url = '/cms/form/fcode/' + fcode;
    return api_request(url);
  },

  //获取表单内容第*页
  getFormPaged: function (fcode, num, paged) {
    var url = '/cms/form/fcode/' + fcode + '/num/' + num + '/page/' + paged;
    return api_request(url);
  },

}